$(document).ready(function() {
    $('#gift-card').change(function() {
        var selectedGiftCardId = $(this).val();

        // Make an AJAX request to retrieve the gift card amounts based on the selected gift card ID
        $.ajax({
            url: '/get-gift-card-amounts',
            type: 'GET',
            data: { giftCardId: selectedGiftCardId },
            success: function(response) {
                // Clear existing options in the gift card amount select
                $('#gift-card-amount').empty();

                // Append the new options based on the response
                $.each(response, function(index, amount) {
                    $('#gift-card-amount').append('<option value="' + amount + '">' + amount + '</option>');
                });
            },
            error: function(xhr, status, error) {
                console.log(error);
            }
        });
    });
});